<?php
// Very basic file-based channel membership tracking (for demonstration)
// WARNING: Not suitable for production. Prone to race conditions and not scalable.

require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Ensure user is logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    http_response_code(403);
    echo json_encode(["success" => false, "message" => "Not authenticated"]);
    exit;
}

$input = json_decode(file_get_contents(
'php://input'
), true);

if (!$input || !isset($input[
'channel_id
'])) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Invalid request"]);
    exit;
}

$channelId = (int)$input[
'channel_id
'];
$userId = $_SESSION[
'id
'];
$username = $_SESSION[
'username
']; // Assuming username is stored in session

$channelDir = 
'/tmp/cortlak_voice_channels/
';
$channelFile = $channelDir . 
'channel_
' . $channelId . 
'.json
';

$members = [];
if (file_exists($channelFile)) {
    $members = json_decode(file_get_contents($channelFile), true) ?: [];
}

// Add user if not already present
if (!isset($members[$userId])) {
    $members[$userId] = ["username" => $username, "joined_at" => time()];
    file_put_contents($channelFile, json_encode($members), LOCK_EX);
}

// Prepare list of other users in the channel
$otherUsers = [];
foreach ($members as $memberId => $memberInfo) {
    if ($memberId != $userId) {
        $otherUsers[] = $memberId; // Send only IDs for initiating connections
    }
}

header(
'Content-Type: application/json'
);
echo json_encode(["success" => true, "users" => $otherUsers]);

?>
