<?php
// Very basic file-based channel membership tracking (for demonstration)
// WARNING: Not suitable for production.

require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Ensure user is logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    http_response_code(403);
    echo json_encode(["success" => false, "message" => "Not authenticated"]);
    exit;
}

$input = json_decode(file_get_contents(
'php://input'
), true);

if (!$input || !isset($input[
'channel_id
'])) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Invalid request"]);
    exit;
}

$channelId = (int)$input[
'channel_id
'];
$userId = $_SESSION[
'id
'];

$channelDir = 
'/tmp/cortlak_voice_channels/
';
$channelFile = $channelDir . 
'channel_
' . $channelId . 
'.json
';

if (file_exists($channelFile)) {
    $fp = fopen($channelFile, 'c+');
    if (flock($fp, LOCK_EX)) { // Acquire exclusive lock
        $content = stream_get_contents($fp);
        $members = json_decode($content, true);
        
        if (is_array($members) && isset($members[$userId])) {
            unset($members[$userId]); // Remove the user
            // Rewind and truncate before writing
            ftruncate($fp, 0);
            rewind($fp);
            fwrite($fp, json_encode($members));
        }
        flock($fp, LOCK_UN); // Release lock
    }
    fclose($fp);
}

// Also clear any pending signals for this user
$signalDir = 
'/tmp/cortlak_signaling/
';
$userSignalFile = $signalDir . 'user_' . $userId . '.json';
if (file_exists($userSignalFile)) {
    unlink($userSignalFile); // Delete the signal file
}

header(
'Content-Type: application/json'
);
echo json_encode(["success" => true, "message" => "Left channel"]);

?>
