# Cortlak.com UI Mockup: Streaming Features

**Goal:** Integrate Kick/Twitch-like streaming capabilities seamlessly into the platform.

**Components:**

1.  **Stream Discovery/Browse Page:**
    - A dedicated section (maybe accessible from the main navigation or a specific icon) to browse live streams.
    - Layout: Grid or list view of currently live streams.
    - Each stream card should display:
        - Streamer's avatar and username.
        - Live thumbnail/preview of the stream.
        - Stream title.
        - Current viewer count.
        - Category/Game being streamed (if implemented).
    - Filtering/Sorting options (e.g., by category, viewer count).

2.  **Stream Viewing Page:**
    - **Layout:** Typically a two-column layout.
        - **Left/Main Column:** Video Player.
        - **Right Column:** Chat.
    - **Video Player Area:**
        - Large video player displaying the live stream.
        - Player controls (play/pause, volume, quality settings, fullscreen).
        - Stream title and streamer's username displayed below or overlaid.
        - Follow/Subscribe button.
        - Viewer count display.
        - Stream status indicator (Live / Offline / Rerun).
    - **Chat Area:**
        - Real-time chat messages associated with the stream.
        - Input field for viewers to type messages.
        - Emoji picker, moderation tools (for streamer/mods).
        - List of viewers currently in chat (optional, can be a toggle).
    - **Streamer Info Panel (Below Player):**
        - Streamer's avatar, username.
        - Stream description.
        - Links to streamer's profile, social media (if configured).
        - Schedule information (if implemented).

3.  **Streamer Dashboard/Settings:**
    - A private section for streamers to manage their stream.
    - **Stream Key:** Display the unique stream key needed for streaming software (OBS, Streamlabs, etc.). Option to regenerate key.
    - **Stream Info:** Fields to set/update stream title, description, category.
    - **Preview:** A small preview of their own stream feed.
    - **Chat Moderation:** Tools to manage chat (timeouts, bans, mod assignments).
    - **Analytics (Optional):** Basic stats like viewer count history, followers gained.
    - **Go Live Button:** Although streaming is initiated from external software, this dashboard confirms the setup.

**Integration with User Profiles:**
- User profiles should indicate if the user is a streamer.
- Link to their stream page from their profile.
- Display live status on their profile.

**Styling:**
- Consistent with the overall application theme.
- Video player should be prominent.
- Chat should be easy to read and follow.
- Clear distinction between streamer messages, mod messages, and regular user messages.

