<?php
// Include config file
// error_log("Login process started."); // Debugging point 1
require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Define variables and initialize with empty values
$login_identifier = $password = "";
$login_identifier_err = $password_err = $login_err = "";

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
    // error_log("POST request received."); // Debugging point 2

    // Check if username/email is empty
    if(empty(trim($_POST["login_identifier"]))){ 
        $login_identifier_err = "Lütfen kullanıcı adı veya e-posta girin.";
    } else{
        $login_identifier = trim($_POST["login_identifier"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST["password"]))){ 
        $password_err = "Lütfen şifrenizi girin.";
    } else{
        $password = trim($_POST["password"]);
    }
    
    // Validate credentials
    if(empty($login_identifier_err) && empty($password_err)){ 
        // error_log("Credentials seem valid, querying database for: " . $login_identifier); // Debugging point 3
        // Prepare a select statement (check both username and email)
        $sql = "SELECT id, username, password_hash FROM users WHERE username = :login_identifier OR email = :login_identifier";
        
        try { // Wrap DB operations in try-catch
            if($stmt = $pdo->prepare($sql)){ 
                // Bind variables to the prepared statement as parameters
                $stmt->bindParam(":login_identifier", $param_login_identifier, PDO::PARAM_STR);
                
                // Set parameters
                $param_login_identifier = $login_identifier;
                
                // Attempt to execute the prepared statement
                if($stmt->execute()){ 
                    // error_log("Database query executed successfully."); // Debugging point 4
                    // Check if username/email exists
                    if($stmt->rowCount() == 1){ 
                        // error_log("User found in database."); // Debugging point 5
                        if($row = $stmt->fetch()){ 
                            $id = $row["id"];
                            $username = $row["username"];
                            $hashed_password = $row["password_hash"];

                            // Verify password
                            // error_log("Verifying password. Input: " . $password . " Hash: " . $hashed_password); // Debugging point 6
                            if(password_verify($password, $hashed_password)){ 
                                // Password is correct, so start/use session
                                // error_log("Password verified successfully for user ID: " . $id); // Debugging point 7

                                // Ensure session is active (should be from config.php)
                                if (session_status() !== PHP_SESSION_ACTIVE) {
                                     // error_log("Session was not active, attempting to start."); // Debugging point 8
                                     session_start(); // Try starting again if somehow inactive
                                }

                                // Store data in session variables
                                $_SESSION["loggedin"] = true;
                                $_SESSION["id"] = $id;
                                $_SESSION["username"] = $username;                            
                                
                                // Verify session variables are set (for debugging)
                                // error_log("Session variables set: " . print_r($_SESSION, true)); // Debugging point 9

                                // Redirect user to welcome page (e.g., index.php)
                                // error_log("Redirecting to index.php"); // Debugging point 10
                                header("location: index.php"); 
                                exit;
                            } else{
                                // Password is not valid
                                // error_log("Password verification failed for user: " . $login_identifier); // Debugging point 11
                                $login_err = "Geçersiz kullanıcı adı/e-posta veya şifre.";
                            }
                        }
                    } else{
                        // Username/email doesn't exist
                        // error_log("User not found for identifier: " . $login_identifier); // Debugging point 12
                        $login_err = "Geçersiz kullanıcı adı/e-posta veya şifre.";
                    }
                } else{
                    // error_log("Database query execution failed."); // Debugging point 13
                    // Use a generic error for the user, but log the specific PDO error if possible
                    $login_err = "Giriş sırasında bir hata oluştu. Lütfen tekrar deneyin.";
                    // Log actual error: error_log("PDO Execute Error: " . print_r($stmt->errorInfo(), true));
                }

                // Close statement
                unset($stmt);
            } else {
                 // error_log("PDO Prepare failed."); // Debugging point 14
                 $login_err = "Giriş sırasında bir veritabanı hatası oluştu.";
                 // Log actual error: error_log("PDO Prepare Error: " . print_r($pdo->errorInfo(), true));
            }
        } catch (PDOException $e) {
            // error_log("PDO Exception: " . $e->getMessage()); // Debugging point 15
            $login_err = "Giriş sırasında kritik bir veritabanı hatası oluştu.";
            // In production, just log the error, don't show details to user
            // die("ERROR: Could not execute $sql. " . $e->getMessage()); // Avoid die() in production
        }
    } else {
         // error_log("Login validation failed. Identifier Error: " . $login_identifier_err . " Password Error: " . $password_err); // Debugging point 16
    }
    
    // Close connection (optional, PHP usually handles this)
    // unset($pdo); // Let script end handle it
}

// If there were errors, or if it's a GET request, the login.php script will display the form and errors.
// error_log("Login process script finished. Login Error: " . $login_err); // Debugging point 17
?>
