<?php
require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Check if the user is logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: ../login.php"); // Redirect to login if not logged in
    exit;
}

$channel_name = "";
$channel_type = "text"; // Default to text
$group_id = null;
$channel_name_err = "";
$channel_type_err = "";
$general_err = "";

// Check if group_id is provided (e.g., via GET or POST)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (empty(trim($_POST["group_id"]))) {
        $general_err = "Group ID is missing.";
    } else {
        $group_id = (int)$_POST["group_id"];
    }

    // Validate channel name
    if (empty(trim($_POST["channel_name"]))) {
        $channel_name_err = "Please enter a channel name.";
    } elseif (!preg_match('/^[a-zA-Z0-9_-]+$/', trim($_POST["channel_name"]))) {
        // Simple validation: letters, numbers, underscore, hyphen
        $channel_name_err = "Channel name can only contain letters, numbers, underscores, and hyphens.";
    } else {
        $channel_name = trim($_POST["channel_name"]);
    }

    // Validate channel type
    if (empty($_POST["channel_type"]) || !in_array($_POST["channel_type"], ["text", "voice"])) {
        $channel_type_err = "Invalid channel type selected.";
    } else {
        $channel_type = $_POST["channel_type"];
    }

    // If no errors so far, check permissions and insert
    if (empty($channel_name_err) && empty($channel_type_err) && empty($general_err)) {
        $user_id = $_SESSION["id"];

        // Check if the user is a member of the group (basic permission check for now)
        // In a real app, you'd check for specific roles/permissions
        $sql_check_member = "SELECT 1 FROM group_members WHERE user_id = :user_id AND group_id = :group_id";
        $stmt_check = $pdo->prepare($sql_check_member);
        $stmt_check->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        $stmt_check->bindParam(":group_id", $group_id, PDO::PARAM_INT);
        $stmt_check->execute();

        if ($stmt_check->rowCount() > 0) {
            // User is a member, proceed to create channel
            $sql_insert_channel = "INSERT INTO channels (group_id, name, type) VALUES (:group_id, :name, :type)";
            if ($stmt_insert = $pdo->prepare($sql_insert_channel)) {
                $stmt_insert->bindParam(":group_id", $group_id, PDO::PARAM_INT);
                $stmt_insert->bindParam(":name", $channel_name, PDO::PARAM_STR);
                $stmt_insert->bindParam(":type", $channel_type, PDO::PARAM_STR);

                if ($stmt_insert->execute()) {
                    // Redirect back to the group page
                    header("location: ../index.php?group_id=" . $group_id);
                    exit;
                } else {
                    $general_err = "Failed to create channel. Please try again.";
                }
                unset($stmt_insert);
            }
        } else {
            $general_err = "You do not have permission to create channels in this group.";
        }
        unset($stmt_check);
    }
    
    // Close connection if errors occurred before redirect
    if (!empty($general_err) || !empty($channel_name_err) || !empty($channel_type_err)) {
         unset($pdo);
         // Need to pass errors back to the form - best done via session or query params
         // For simplicity, we'll just redirect with a generic error for now if needed, or handle in the form itself.
         // Let's assume the form (create_channel.php) will include this file and display errors.
    }

} else {
    // If accessed via GET, expect group_id in query string
    if (empty(trim($_GET["group_id"]))) {
        // Redirect or show error if no group context
        header("location: ../index.php?error=nogroupid");
        exit;
    } else {
        $group_id = (int)$_GET["group_id"];
        // Verify user is member of this group before showing the form
        $user_id = $_SESSION["id"];
        $sql_check_member = "SELECT 1 FROM group_members WHERE user_id = :user_id AND group_id = :group_id";
        $stmt_check = $pdo->prepare($sql_check_member);
        $stmt_check->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        $stmt_check->bindParam(":group_id", $group_id, PDO::PARAM_INT);
        $stmt_check->execute();
        if ($stmt_check->rowCount() == 0) {
             header("location: ../index.php?error=notmember");
             exit;
        }
        unset($stmt_check);
    }
}

// If we reach here via POST with errors, or via GET, the variables $group_id, $channel_name_err, etc. are set for the form.
?>
