<?php
// RTMP Callback Handler - On Publish Start
// WARNING: This is a simplified example. Real-world implementation needs robust security (e.g., validating requests come from the RTMP server).

require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Assuming the RTMP server sends the stream key in a POST variable named 'name' or 'key'
// Adjust the variable name based on your RTMP server's configuration (e.g., nginx-rtmp-module often uses 'name')
$stream_key = $_POST['name'] ?? $_POST['key'] ?? null;

if ($stream_key) {
    // Find the user associated with this stream key
    $sql = "UPDATE streams SET is_live = 1, last_live_at = datetime('now') WHERE stream_key = :stream_key";
    
    try {
        if ($stmt = $pdo->prepare($sql)) {
            $stmt->bindParam(":stream_key", $stream_key, PDO::PARAM_STR);
            
            if ($stmt->execute()) {
                if ($stmt->rowCount() > 0) {
                    // Successfully marked as live
                    http_response_code(200); // OK
                    // Optionally log success
                    // error_log("Stream started: " . $stream_key);
                } else {
                    // Stream key not found or already marked live (no change)
                    http_response_code(404); // Not Found (or maybe 200 if no error needed)
                    // error_log("Stream key not found for start: " . $stream_key);
                }
            } else {
                // SQL execution error
                http_response_code(500); // Internal Server Error
                // error_log("SQL error on stream start: " . $stream_key);
            }
            unset($stmt);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        // error_log("PDO Exception on stream start: " . $e->getMessage());
    }
    unset($pdo);

} else {
    // Stream key not provided in the request
    http_response_code(400); // Bad Request
    // error_log("Missing stream key on publish start callback.");
}

// The RTMP server usually expects a specific HTTP status code.
// 2xx indicates success, allowing the stream.
// Non-2xx (like 4xx or 5xx) might cause the server to reject the stream.
?>
