<?php
// Very basic file-based signaling server (polling endpoint)
// WARNING: This is NOT suitable for production.

require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Ensure user is logged in (basic check)
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    http_response_code(403);
    echo json_encode([]); // Return empty array on auth failure
    exit;
}

if (!isset($_GET["user_id"]) || !isset($_GET["channel_id"])) {
    http_response_code(400);
    echo json_encode([]); // Return empty array on bad request
    exit;
}

$userId = (int)$_GET["user_id"];
$channelId = (int)$_GET["channel_id"];

// Basic validation: Ensure the requesting user ID matches the session user ID
if ($userId !== $_SESSION["id"]) {
    http_response_code(403);
    echo json_encode([]);
    exit;
}

// Retrieve and clear signals for the user
$signalDir = 
'/tmp/cortlak_signaling/
';
$userSignalFile = $signalDir . 'user_' . $userId . '.json';

$signalsToSend = [];

if (file_exists($userSignalFile)) {
    // Use file locking to prevent race conditions
    $fp = fopen($userSignalFile, 'r+');
    if (flock($fp, LOCK_EX)) { // Acquire exclusive lock
        $content = stream_get_contents($fp);
        $signals = json_decode($content, true);
        
        if (is_array($signals)) {
            $signalsToSend = $signals;
            // Clear the file after reading
            ftruncate($fp, 0);
        }
        flock($fp, LOCK_UN); // Release lock
    }
    fclose($fp);
}

header(
'Content-Type: application/json
');
echo json_encode($signalsToSend);

?>
