<?php
// Very basic file-based signaling server (for demonstration purposes)
// WARNING: This is NOT suitable for production. It lacks proper security, error handling, and scalability.
// It uses temporary files for simplicity in this environment.

require_once dirname(__DIR__, 2) . '/config/config.php';

// Ensure user is logged in (basic check)
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['to_user_id']) || !isset($input['data']) || !isset($input['from_user_id']) || !isset($input['channel_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

$toUserId = (int)$input['to_user_id'];
$fromUserId = (int)$input['from_user_id'];
$channelId = (int)$input['channel_id'];
$data = $input['data'];

// Basic validation: Ensure sender is actually in the channel (optional but good practice)
// $channelFile = "/tmp/cortlak_voice_channels/channel_" . $channelId . ".json";
// if (file_exists($channelFile)) {
//     $members = json_decode(file_get_contents($channelFile), true) ?: [];
//     if (!in_array($fromUserId, $members)) {
//         http_response_code(403);
//         echo json_encode(['success' => false, 'message' => 'Sender not in channel']);
//         exit;
//     }
// } else {
//      http_response_code(404);
//      echo json_encode(['success' => false, 'message' => 'Channel not found']);
//      exit;
// }


// Store the signal message for the recipient
$signalDir = '/tmp/cortlak_signaling/';
$userSignalFile = $signalDir . 'user_' . $toUserId . '.json';

$signals = [];
if (file_exists($userSignalFile)) {
    $signals = json_decode(file_get_contents($userSignalFile), true);
    if (!is_array($signals)) { // Handle potential file corruption
        $signals = [];
    }
}

$signals[] = [
    'from_user_id' => $fromUserId,
    'timestamp' => time(),
    'data' => $data
];

// Limit stored signals per user to prevent excessive file growth (e.g., last 50)
if (count($signals) > 50) {
    $signals = array_slice($signals, -50);
}

if (file_put_contents($userSignalFile, json_encode($signals), LOCK_EX) === false) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to write signal file.']);
} else {
    echo json_encode(['success' => true, 'message' => 'Signal stored.']);
}

?>
