<?php
define('DB_FILE', dirname(__DIR__) . '/database/cortlak.db');

// Attempt to connect to SQLite database
try {
    $pdo = new PDO('sqlite:' . DB_FILE);
    // Set the PDO error mode to exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Optional: Set default fetch mode
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e){
    // In production, log this error instead of displaying it
    die("ERROR: Could not connect. " . $e->getMessage());
}

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Base URL (useful for redirects and links)
define('BASE_URL', '/'); // Adjust if needed, assuming it runs at the root for now

?>
