# Cortlak.com UI Mockup: Login/Register Page

**Goal:** Provide a clean, modern, and straightforward interface for user login and registration.

**Layout:**
- Centered content block on a simple background (maybe a subtle gradient or image).
- Width of the content block should be responsive, suitable for both desktop and mobile.

**Elements:**

1.  **Logo/App Name:** "Cortlak.com" prominently displayed at the top of the content block.
2.  **Form Title:** Changes based on context ("Login" or "Register").
3.  **Input Fields (Login):**
    - Email or Username (Label: "Email or Username", Placeholder: "Enter your email or username")
    - Password (Label: "Password", Type: password, Placeholder: "Enter your password")
4.  **Input Fields (Register):**
    - Username (Label: "Username", Placeholder: "Choose a username")
    - Email (Label: "Email", Type: email, Placeholder: "Enter your email address")
    - Password (Label: "Password", Type: password, Placeholder: "Create a password")
    - Confirm Password (Label: "Confirm Password", Type: password, Placeholder: "Confirm your password")
5.  **Submit Button:**
    - Text: "Login" or "Register"
    - Full width within the content block.
6.  **Links:**
    - Below the submit button.
    - For Login page: "Need an account? Register" (links to registration view)
    - For Register page: "Already have an account? Login" (links to login view)
    - Optional: "Forgot your password?" link on the Login page.
7.  **Error/Success Messages:** Area above the input fields to display messages (e.g., "Invalid credentials", "Registration successful", "Passwords do not match").

**Styling:**
- Modern font.
- Minimalist color scheme (e.g., dark theme similar to Discord or a light theme).
- Clear visual hierarchy.
- Input fields with clear focus states.
- Smooth transitions between login and register views (if done on the same page).

