# Cortlak.com UI Mockup: User Profile Page

**Goal:** Allow users to view and potentially edit their own profile, and view profiles of other users.

**Layout:**
- Could be a modal overlay or a dedicated page/section within the application.
- Typically features a header/banner area and a main content area.

**Elements:**

1.  **Profile Header:**
    - **Banner Image:** Customizable banner image at the top.
    - **Avatar:** Large user avatar, potentially overlapping the banner slightly.
    - **Username & Discriminator/Tag:** User's unique identifier.
    - **Status Indicator:** Online, Idle, Do Not Disturb, Offline.
    - **Action Buttons (Contextual):**
        - *Own Profile:* "Edit Profile", "Account Settings".
        - *Other User's Profile:* "Send Message", "Add Friend" (if not friends), "Remove Friend" / "Block" (if friends).

2.  **Main Content Area (Tabs or Sections):**
    - **About Me:**
        - Custom bio section (editable by the profile owner).
        - Member since date.
    - **Groups/Servers:**
        - List of mutual groups/servers shared with the viewing user.
        - Maybe a list of all public groups the user is in (privacy setting dependent).
    - **Activity/Status:**
        - Current activity (e.g., "Playing Game X", "Listening to Spotify").
    - **Stream Info (If applicable):**
        - Link to their stream channel if they are a streamer on Cortlak.com.
        - Current stream status (Live / Offline).
        - Stream title.
    - **Connections (Optional):**
        - Linked external accounts (Twitch, YouTube, etc. - if implemented).

**Editing Own Profile:**
- Clicking "Edit Profile" would make fields like Banner, Avatar, Bio editable.
- Separate sections for changing username, email, password would likely be in "Account Settings" rather than the public profile view.

**Styling:**
- Consistent with the overall application theme.
- Clear separation between sections.
- Visually appealing presentation of user information.
- Responsive design.

