<?php
// Include the processing logic which also handles GET request validation (group_id, membership)
require_once dirname(__DIR__) . 
'/app/channels/create_channel_process.php';

// Ensure $group_id is set from the process script
if (!isset($group_id)) {
    // This should ideally not happen if the process script handles redirection correctly
    die("Error: Group ID not found."); 
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create New Channel - Cortlak.com</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: sans-serif; background-color: #f4f4f4; margin: 0; padding: 40px; display: flex; justify-content: center; align-items: center; min-height: 100vh; box-sizing: border-box; }
        .wrapper { background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 100%; max-width: 400px; }
        h2 { text-align: center; color: #333; margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; color: #555; }
        input[type="text"], select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .help-block { color: #dc3545; font-size: 0.9em; margin-top: 5px; }
        .alert-danger { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; padding: 10px; border-radius: 4px; margin-bottom: 15px; }
        .btn { display: inline-block; width: 100%; padding: 10px; background-color: #5cb85c; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 1em; text-align: center; }
        .btn:hover { background-color: #4cae4c; }
        a { color: #007bff; text-decoration: none; }
        a:hover { text-decoration: underline; }
        .cancel-link { display: block; text-align: center; margin-top: 15px; }
    </style>
</head>
<body>
    <div class="wrapper">
        <h2>Create Channel</h2>
        <p>Create a new text or voice channel in your group.</p>

        <?php 
        if(!empty($general_err)){ 
            echo 
'<div class="alert alert-danger">' . htmlspecialchars($general_err) . '</div>';
        }
        ?>

        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <input type="hidden" name="group_id" value="<?php echo htmlspecialchars($group_id); ?>">
            
            <div class="form-group <?php echo (!empty($channel_name_err)) ? 'has-error' : ''; ?>">
                <label>Channel Name</label>
                <input type="text" name="channel_name" value="<?php echo htmlspecialchars($channel_name); ?>" placeholder="e.g., general, gaming, music">
                <span class="help-block"><?php echo $channel_name_err; ?></span>
            </div>    
            
            <div class="form-group <?php echo (!empty($channel_type_err)) ? 'has-error' : ''; ?>">
                <label>Channel Type</label>
                <select name="channel_type">
                    <option value="text" <?php echo ($channel_type == 'text') ? 'selected' : ''; ?>>Text Channel</option>
                    <option value="voice" <?php echo ($channel_type == 'voice') ? 'selected' : ''; ?>>Voice Channel</option>
                </select>
                <span class="help-block"><?php echo $channel_type_err; ?></span>
            </div>
            
            <div class="form-group">
                <input type="submit" class="btn" value="Create Channel">
            </div>
            <a href="index.php?group_id=<?php echo htmlspecialchars($group_id); ?>" class="cancel-link">Cancel</a>
        </form>
    </div>    
</body>
</html>
