<?php
// Include config file & ensure user is logged in
require_once dirname(__DIR__) . '/config/config.php';

// Check if the user is logged in, otherwise redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

// Include the processing script logic. It defines $group_name_err if there was a POST request with errors.
// We define it here first to avoid undefined variable warnings on initial GET request.
$group_name_err = ""; 
include dirname(__DIR__) . '/app/groups/create_group_process.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create New Group - Cortlak.com</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: sans-serif; background-color: #f4f4f4; margin: 0; padding: 40px; display: flex; justify-content: center; align-items: center; min-height: 100vh; box-sizing: border-box; }
        .wrapper { background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 100%; max-width: 400px; }
        h2 { text-align: center; color: #333; margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; color: #555; }
        input[type="text"] { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .help-block { color: #dc3545; font-size: 0.9em; margin-top: 5px; }
        .btn { display: inline-block; width: 100%; padding: 10px; background-color: #5cb85c; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 1em; text-align: center; }
        .btn:hover { background-color: #4cae4c; }
        a { color: #007bff; text-decoration: none; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="wrapper">
        <h2>Create a New Group</h2>
        <p>Give your new server a name.</p>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group <?php echo (!empty($group_name_err)) ? 'has-error' : ''; ?>">
                <label>Group Name</label>
                <input type="text" name="group_name" value="<?php echo htmlspecialchars($group_name); ?>" placeholder="Enter group name">
                <span class="help-block"><?php echo $group_name_err; ?></span>
            </div>
            <div class="form-group">
                <input type="submit" class="btn" value="Create Group">
            </div>
            <p><a href="index.php">Cancel</a></p>
        </form>
    </div>    
</body>
</html>
