<?php
require_once dirname(__DIR__) . 
'/config/config.php';

// Check if the user is logged in, otherwise redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    // Maybe return an error for AJAX calls in the future, but for now redirect
    header("location: login.php");
    exit;
}

// Check if it's a POST request and if message and channel_id are set
if($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["message"]) && isset($_POST["channel_id"])){

    $message_content = trim($_POST["message"]);
    $channel_id = (int)$_POST["channel_id"];
    $user_id = $_SESSION["id"];

    // Basic validation
    if(empty($message_content)) {
        // Handle empty message error - maybe redirect back with an error message
        header("location: index.php?group_id=" . $_POST['group_id'] . "&channel_id=" . $channel_id . "&error=empty_message");
        exit;
    }

    if($channel_id <= 0) {
        // Handle invalid channel ID
        header("location: index.php?error=invalid_channel");
        exit;
    }

    // Verify user has access to this channel (is a member of the group)
    $sql_check_access = "SELECT g.id FROM groups g JOIN channels c ON g.id = c.group_id JOIN group_members gm ON g.id = gm.group_id WHERE c.id = :channel_id AND gm.user_id = :user_id";
    $stmt_check = $pdo->prepare($sql_check_access);
    $stmt_check->bindParam(":channel_id", $channel_id, PDO::PARAM_INT);
    $stmt_check->bindParam(":user_id", $user_id, PDO::PARAM_INT);
    $stmt_check->execute();

    if($stmt_check->rowCount() == 1) {
        // User has access, proceed to insert the message
        $sql_insert = "INSERT INTO messages (channel_id, user_id, content) VALUES (:channel_id, :user_id, :content)";
        if($stmt_insert = $pdo->prepare($sql_insert)){
            $stmt_insert->bindParam(":channel_id", $channel_id, PDO::PARAM_INT);
            $stmt_insert->bindParam(":user_id", $user_id, PDO::PARAM_INT);
            $stmt_insert->bindParam(":content", $message_content, PDO::PARAM_STR);

            if($stmt_insert->execute()){
                // Message sent successfully, redirect back to the channel
                // Get group_id for redirect
                $group_id = $stmt_check->fetchColumn(); 
                header("location: index.php?group_id=" . $group_id . "&channel_id=" . $channel_id);
                exit;
            } else {
                // Handle insertion error
                // Log the error properly in a real application
                header("location: index.php?group_id=" . $_POST['group_id'] . "&channel_id=" . $channel_id . "&error=send_failed");
                exit;
            }
            unset($stmt_insert);
        }
    } else {
        // User does not have access to this channel
        header("location: index.php?error=access_denied");
        exit;
    }
    unset($stmt_check);
    unset($pdo);

} else {
    // Not a POST request or missing data, redirect to home
    header("location: index.php");
    exit;
}
?>
